/*-----------------------------------------------------------------------*/
/* Copyright 2012 to current year.                                       */
/* AVEVA Solutions Limited and its subsidiaries. All rights reserved.    */
/*-----------------------------------------------------------------------*/
(function (angular) {
  var netViewWrapper = function () {
    return {
      lastSelection: null,
      netViewWrapperCommands: null,
      netViewWindow: null,
      previousSelection: null,

      setNetViewWindow: function (nvwindow) {
        this.netViewWindow = nvwindow;
      },

      setNetViewWrapperCommands: function (nvwc) {
        this.netViewWrapperCommands = nvwc;
      },

      // Tells NetView that it's inside AVEVANET
      informNetView: function () {
        this.postMessageToNetView('AVEVANET', '');
      },

      selection: function (id, classId) {
        switch (classId) {
          case 'BUBBLEVIEW':
            this.openBubble(id);
            break;
          default:
            this.selectObject(id);
        }
      },

      //add more as needed;
      openProjectWithSSO: function (project) {
        if (this.netViewWindow) {
          this.postMessageToNetView('openSSOProject', { project });
        }
      },

      openBubble: function (bubbleViewName) {
        if (this.netViewWindow) {
          this.postMessageToNetView('openScan', { bubbleViewName });
        }
      },

      selectObject: function (objId) {
        if (this.netViewWindow) {
          this.postMessageToNetView('selectObject', { objId });
        }
      },

      highlightOrCreateMarkup: function (name, colour) {
        if (this.netViewWindow) {
          this.postMessageToNetView('highlightOrCreateMarkup', {
            name,
            colour
          });
        }
      },

      postMessageToNetView: function (actionName, params) {
        var functionName = this.netViewWrapperCommands[actionName]();
        if (this.netViewWindow.contentWindow) {
          this.netViewWindow.contentWindow.postMessage(
            { functionName, params },
            '*'
          );
        }
      }
    };
  };

  var netViewListener = function () {
    return {
      picked: null,
      lastMessage: null,
      notificationsEnabled: true,
      netviewListenerCommands: null,
      subscribers: [],

      setNetviewListenerCommands: function (netviewListenerCommands) {
        this.netviewListenerCommands = netviewListenerCommands;
      },

      subscribeForEvent: function (event, callback) {
        this.subscribers.push({
          event,
          callback
        });
      },

      notifySubscribers: function (event, data) {
        this.subscribers.forEach(function (sub) {
          if (sub.event === event) {
            sub.callback(data);
          }
        });
      },

      setupEventCallback: function (anetWindow) {
        anetWindow.addEventListener(
          'message',
          function (message) {
            this.handleMessage(message);
          }.bind(this),
          false
        );
      },

      addNotifyFunction: function (func) {
        this.picked = func;
      },

      handleMessage: function (message) {
        this.lastMessage = message.data;
        this.netviewListenerCommands(message, this);
      },

      getLastMessage: function () {
        return this.lastMessage;
      },

      sendNotification: function () {
        return this.notificationsEnabled;
      },

      resumeNotifications: function () {
        this.notificationsEnabled = true;
      },

      suspendNotifications: function () {
        this.notificationsEnabled = false;
      }
    };
  };

  var aNetDashModule = angular.module('aveva.dashboard.custom');

  aNetDashModule.factory('NetViewWrapper', function () {
    return netViewWrapper;
  });

  aNetDashModule.factory('NetViewListener', function () {
    return netViewListener;
  });
  // eslint-disable-next-line no-undef
})(angular);
